unit Unit1;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Forms, Controls, Graphics, Dialogs, ExtCtrls, Buttons,
  StdCtrls, LCLType, Unit2;

type

  { TForm1 }

  TForm1 = class(TForm)
    Image1: TImage;
    Label1: TLabel;
    Label2: TLabel;
    Memo1: TMemo;
    Panel1: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    Timer1: TTimer;
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    t1,t2,t3:tdatetime;
    r,s:array[1..8]of integer;
  public

  end;

var
  Form1: TForm1;
implementation

{$R *.lfm}

{ TForm1 }

procedure TForm1.FormCreate(Sender: TObject);
begin
  with image1.Canvas do
  begin
    brush.Color:=clwhite; //塗る色を青にする
    fillrect (image1.Canvas.ClipRect); //「Image1.Canvas.ClipRect」はimage全体を表す
    font.Color:=clblack;
    font.Size:=30;
    textout(5,5,'0');
    textout(30,5,'0');
    textout(60,2,':');
    textout(80,5,'0');
    textout(105,5,'0');
    textout(130,5,'’');
    textout(155,5,'0');
    textout(180,5,'0');
    textout(205,5,'”');
    textout(230,5,'0');
    textout(255,5,'0');
  end;
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState
  );
begin
  if key=VK_RETURN then begin
    SpeedButton1Click(Sender);
  end;
  if key=VK_SPACE then begin
    SpeedButton2Click(Sender);
  end;
  if key=VK_ESCAPE then begin
    form1.Close;
  end;

end;

procedure TForm1.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin

  if memo1.Tag=1 then begin
    form2.ShowModal;
    if form2.Tag=1 then speedbutton3.OnClick(sender);
  end;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
var
   hour,min,sec,msec:word;
   ye,mo,da:word;
   str:string;
begin
  if SpeedButton1.Caption='スタート' then begin
    t1:=time-t2;
    timer1.Enabled:=true;
    SpeedButton1.Caption:='ストップ';
    SpeedButton2.Caption:='ラップ';
    if speedbutton1.Tag=0 then begin
      decodedate(now,ye,mo,da);
      decodetime(now,hour,min,sec,msec);
      str:=inttostr(mo)+'月'+inttostr(da)+'日';
      str:=str+inttostr(hour)+'時'+inttostr(min)+'分'+inttostr(sec)+'秒記録';
      memo1.Lines.add(str);
      speedbutton1.Tag:=1;
      memo1.Tag:=2;
    end else begin
      //再スタートの時
      decodetime(now,hour,min,sec,msec);
      str:=inttostr(hour)+'時'+inttostr(min)+'分'+inttostr(sec)+'秒';
      if msec<100 then str:=str+'0';
      str:=str+inttostr(msec div 10)+'再スタート';
      memo1.Lines.add(str);
    end;
  end else begin
    timer1.Enabled:=false;
    //memo1に記録する
    decodetime(t2,hour,min,sec,msec);
    SpeedButton2.Tag:=SpeedButton2.Tag+1;
    str:=inttostr(SpeedButton2.Tag)+'  ';
    if hour<10 then str:=str+'0';
    str:=str+inttostr(hour)+'：';
    if min<10 then str:=str+'0';
    str:=str+inttostr(min)+'’';
    if sec<10 then str:=str+'0';
    str:=str+inttostr(sec)+'”';
    if msec<100 then str:=str+'0';
    str:=str+inttostr(msec div 10);
    memo1.Lines.add(str);
    memo1.Lines.add('終了');
    //memo1に記録する終了
    t2:=time-t1;
    SpeedButton1.Caption:='スタート';
    SpeedButton2.Caption:='リセット';
    memo1.Tag:=1;
  end;
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
var
  hour,min,sec,msec:word;
  str:string;
begin
  if SpeedButton2.Caption='リセット' then begin
    t2:=0;
    SpeedButton1.Tag:=0;
    SpeedButton2.Tag:=0;
    memo1.Lines.add(#10#13);
    with image1.Canvas do begin
      font.Color:=clblack;
      font.Size:=30;
      textout(5,5,'0');
      textout(30,5,'0');
      textout(60,2,':');
      textout(80,5,'0');
      textout(105,5,'0');
      textout(130,5,'’');
      textout(155,5,'0');
      textout(180,5,'0');
      textout(205,5,'”');
      textout(230,5,'0');
      textout(255,5,'0');
    end;
  end else begin
    t3:=time-t1;
    decodetime(t2,hour,min,sec,msec);
    SpeedButton2.Tag:=SpeedButton2.Tag+1;
    str:=inttostr(SpeedButton2.Tag)+'  ';
    if hour<10 then str:=str+'0';
    str:=str+inttostr(hour)+'：';
    if min<10 then str:=str+'0';
    str:=str+inttostr(min)+'’';
    if sec<10 then str:=str+'0';
    str:=str+inttostr(sec)+'”';
    if msec<100 then str:=str+'0';
    str:=str+inttostr(msec div 10);
    memo1.Lines.add(str);
  end;
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
  if memo1.Tag=2 then exit;
  if memo1.Tag=1 then begin
    memo1.Lines.SaveToFile(memo1.Lines[0]+'.txt');
    SpeedButton1.Tag:=0;
    SpeedButton2.Tag:=0;
    memo1.Tag:=0;
    memo1.Text:='';
  end;
end;

procedure TForm1.SpeedButton4Click(Sender: TObject);
begin
  form1.close;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
  hour,min,sec,msec:word;
begin
  t2:=time-t1;
  decodetime(t2,hour,min,sec,msec);

  r[8]:=hour div 10;
  r[7]:=hour mod 10;

  r[6]:=min div 10;
  r[5]:=min mod 10;

  r[4]:=sec div 10;
  r[3]:=sec mod 10;

  r[2]:=msec div 100;
  r[1]:=(msec div 10) mod 10;

  with image1.Canvas do
  begin
    font.Color:=clblack;
    font.Size:=30;
    textout(255,5,inttostr(r[1]));
    if r[2]=s[2] then exit;
    textout(230,5,inttostr(r[2]));
    s[2]:=r[2];
    if r[3]=s[3] then exit;
    textout(180,5,inttostr(r[3]));
    s[3]:=r[3];
    if r[4]=s[4] then exit;
    textout(155,5,inttostr(r[4]));
    s[4]:=r[4];
    if r[5]=s[5] then exit;
    textout(105,5,inttostr(r[5]));
    s[5]:=r[5];
    if r[6]=s[6] then exit;
    textout(80,5,inttostr(r[6]));
    s[6]:=r[6];
    if r[7]=s[7] then exit;
    textout(30,5,inttostr(r[7]));
    s[7]:=r[7];
    if r[8]=s[8] then exit;
    textout(5,5,inttostr(r[8]));
  end;
end;

end.

